'This BMX file was edited with BLIde ( http://www.blide.org )
Rem
 bbdoc:Undocumented type
End Rem
Type TPauseScreen Extends TScreen

	Field _title:String
	Field _details:TStringBuilder
	Field _blackShade:TColor
	Field _menu:TList = CreateList() 
	
	Method New() 
		_blackShade = TColor.Create(130, 0, 0, 0)
	End Method
	
	Function Create:TPauseScreen(title:String, details:TStringBuilder)
		Local p:TPauseScreen = New TPauseScreen
		p._title = title
		p._details = details
		Return p
	End Function
	
	Method Draw(delta:Float) 
		SetOrigin(0, 0) 
		SetAlpha(1) 
		_blackShade.Set() 
		Local width:Float = TDemo.gfxWidth *.80
		Local height:Float = TDemo.gfxHeight *.80
		Local x:Float = (TDemo.gfxWidth - width) / 2
		Local y:Float = (TDemo.gfxHeight - height) / 2
		DrawRect(x, y, width, height)
		SetAlpha(160.0 / 255.0)
		DrawRect(x + width / 4, y, width - (width / 4), height) 
		_blackShade.Reset() 
		
		DrawText(_title, 15 + x + width / 4, y + 15) 
		_details.Draw(15 + x + width / 4, y + 100)
		
		For Local me:MenuEntry = EachIn _menu
			me.Draw() 
		Next
	End Method
	
	Method Update(delta:Float) 
		Local ms:Int = ScreenManager.Instance().GetInput().CurrentMouseLeftHit' MouseHit(1) 
		For Local me:MenuEntry = EachIn _menu
			me.Update(ms) 
			If me.WasClicked() Then
				HandleMenuClick(me) 
			End If
		Next

	End Method
	
	
	Method OnEscapeKeyHit() 
		ScreenManager.Instance().RemoveAll() 
		ScreenManager.Instance().AddScreen(New MainMenuScreen) 			
	End Method
	
	Method HandleMenuClick(me:MenuEntry) 
		Select me.GetId() 
			Case 1 ' resume
				Self.ExitScreen() 
			Case 2 ' quit to main menu
				ScreenManager.Instance().RemoveAll() 
				ScreenManager.Instance().AddScreen(New MainMenuScreen) 
		End Select
	End Method
	
	Method Unload() 
		
	End Method
	
	Method Load() 
		Local width:Float = TDemo.gfxWidth *.80
		Local height:Float = TDemo.gfxHeight *.80
		Local x:Float = (TDemo.gfxWidth - width) / 2
		Local y:Float = (TDemo.gfxHeight - height) / 2
		Local resume:MenuEntry = MenuEntry.Create(1, "Resume Demo", x + 15, y + 100) 
		Local quit:MenuEntry = MenuEntry.Create(2, "Quit Demo", x + 15, y + 200) 
		_menu.AddLast(resume) 
		_menu.AddLast(quit) 
	End Method
End Type
